<?php
/*
  Plugin Name: HnP - Ladezeit-Konsole
  Description: Messen Sie Ihre Ladezeiten und lesen Sie die Werte in der Browserkonsole aus.
  Author: Christopher Rohde
  Version: 1.1
  Author URI: https://homepage-nach-preis.de/
  License: GPLv3
 */

$plugin_url = WP_PLUGIN_URL . '/hnp-loading-time-console';
$options = array(); 

function hnp_LTC_menu() {
add_menu_page('HnP-Ladezeit-Konsole', 'HnP-Ladezeit-Konsole', 'manage_options', 'hnp_LTC_options', 'hnp_LTC_display', plugin_dir_url( __FILE__ ) . 'hnp-favi.png' );
}
add_action('admin_menu', 'hnp_LTC_menu'); 

function hnp_LTC_display() { 
if (!current_user_can('manage_options')) { wp_die('You do not have enough permission to view this page'); 
} 

global $plugin_url;
global $options;

    if (isset($_POST['form_submit']))
	
      {
        require_once (ABSPATH . 'wp-admin/includes/image.php');
        require_once (ABSPATH . 'wp-admin/includes/file.php');
        require_once (ABSPATH . 'wp-admin/includes/media.php');
		
        echo '<br><br><h2 style="color:green">Gespeichert</h2>';
		
       
		
		 if ( isset( $_POST['hnp_loading_time_checked'] ) ) {
            $options['hnp_loading_time_checked'] = esc_html( $_POST['hnp_loading_time_checked'] );
                } else {
                    $options['hnp_loading_time_checked'] = '';
                }
		 

		update_option('hnp-loading-time-console', $options); 
	  }
$options = get_option('hnp-loading-time-console');
	
require ('inc/options-page-wrapper.php');
}

add_action('wp_head', 'hnp_loading_time_header');
function hnp_loading_time_header(){
	$options = get_option('hnp-loading-time-console');		
	if ($options['hnp_loading_time_checked'] != ''){
	?>
	<script> var start = new Date().getTime(); window.onload = function() { var end = new Date().getTime(); console.log('Loading time (in milliseconds): ' + (end - start)); }</script><script> window.addEventListener('load', function() {  var now = new Date().getTime(); console.log('Perceived loading time (in milliseconds): ' + (now - performance.timing.navigationStart)); });</script>
<?php }
};
