<?php
/*
Plugin Name: HnP - Image Title Remove
Description: Entfernt die Title Tags von Bildern - kompatibel mit dem VisualComposer.
Author: Christopher Rohde
Version: 1.1
Author URI: https://homepage-nach-preis.de/
License: GPLv3
*/

$plugin_url = WP_PLUGIN_URL . "/hnp-remove-image-title";
$options = [];

function hnp_itr_menu()
{
    add_menu_page(
        "HnP-image-Title-Remove",
        "HnP-image-Title-Remove",
        "manage_options",
        "hnp_itr_options",
        "hnp_itr_display",
        plugin_dir_url(__FILE__) . "hnp-favi.png"
    );
}
add_action("admin_menu", "hnp_itr_menu");

function hnp_itr_display()
{
    if (!current_user_can("manage_options")) {
        wp_die("You do not have enough permission to view this page");
    }

    global $plugin_url;
    global $options;

    if (isset($_POST["form_submit"])) {
        require_once ABSPATH . "wp-admin/includes/image.php";
        require_once ABSPATH . "wp-admin/includes/file.php";
        require_once ABSPATH . "wp-admin/includes/media.php";

        echo '<br><br><h2 style="color:green">Gespeichert</h2>';

        if (isset($_POST["hnp_image_title_remove_checked"])) {
            $options["hnp_image_title_remove_checked"] = esc_html(
                $_POST["hnp_image_title_remove_checked"]
            );
        } else {
            $options["hnp_image_title_remove_checked"] = "";
        }

        update_option("hnp-loading-time-console", $options);
    }
    $options = get_option("hnp-loading-time-console");

    require "inc/options-page-wrapper.php";
}

add_action("wp_head", "hnp_loading_time_header");
function hnp_loading_time_header()
{
    $options = get_option("hnp-loading-time-console");
    if ($options["hnp_image_title_remove_checked"] != "") {
        add_filter("the_content", "hnp_remove_img_title", 9999);
        add_filter("wp_get_attachment_image", "hnp_remove_img_title", 9999);
        add_filter("post_thumbnail_html", "hnp_remove_img_title", 9999);

        function hnp_remove_img_title($text)
        {
            $result = [];
            preg_match_all('|title="[^"]*"|U', $text, $result);
            foreach ($result[0] as $img_tag) {
                $text = str_replace($img_tag, "", $text);
            }
            return $text;
        }
    }
}
?> 