<?php
/*
Plugin Name: Mein Plugin - HNP Edition
Description: Ein WordPress Plugin mit Option-Seite und Shortcode - HNP Edition.
Author: Christopher Rohde
Version: 1.0
Author URI: https://homepage-nach-preis.de/
License: GPLv3
*/

// ABSPATH -- Schützt vor direkte Zugriffe auf die Plugin-Datei
defined('ABSPATH') or die('Huh, are you trying to cheat?');

// Fügt die Option-Seite im Backend hinzu -- current_user_can gewährleistet, dass nur User mit ausreichenden Rechten auf die Options-Seite zugreifen können
// esc_html() gewährleistet, dass die Ausgabe nicht als ausführbarer Code interpretiert wird
function hnp_mein_plugin_option_page() {
    if (!current_user_can('manage_options')) {
        wp_die('You do not have enough permission to view this page');
    }

    add_options_page('Mein Plugin Optionen - HNP', 'Mein Plugin - HNP', 'manage_options', 'hnp-mein-plugin', 'hnp_mein_plugin_option_page_content');
}
add_action('admin_menu', 'hnp_mein_plugin_option_page');

// Funktion für den Inhalt der Option-Seite
function hnp_mein_plugin_option_page_content() {
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('Mein Plugin Einstellungen - HNP', 'hnp'); ?></h1>
        <form method="post" action="options.php">
            <?php
            // Fügt die WordPress Einstellungsfelder hinzu
            settings_fields('hnp_mein_plugin_settings');
            do_settings_sections('hnp-mein-plugin');
            submit_button(esc_html__('Speichern', 'hnp'));
            ?>
        </form>
    </div>
    <?php
}

// Funktion für die Erstellung der Einstellungsfelder -- sanitize_text_field unerwünschte HTML- oder JavaScript-Tags entfernen
function hnp_mein_plugin_settings_init() {
    add_settings_section('hnp_mein_plugin_section', esc_html__('Allgemeine Einstellungen - HNP', 'hnp'), 'hnp_mein_plugin_section_callback', 'hnp-mein-plugin');
    add_settings_field('hnp_mein_plugin_text_input', esc_html__('Text Input - HNP', 'hnp'), 'hnp_mein_plugin_text_input_callback', 'hnp-mein-plugin', 'hnp_mein_plugin_section');
    register_setting('hnp_mein_plugin_settings', 'hnp_mein_plugin_text_input', 'sanitize_text_field');
}
add_action('admin_init', 'hnp_mein_plugin_settings_init');

// Callback-Funktion für die Sektionsüberschrift
function hnp_mein_plugin_section_callback() {
    echo esc_html__('Hier können Sie Ihre Einstellungen vornehmen - HNP.', 'hnp');
}

// Callback-Funktion für das Text-Input Feld
function hnp_mein_plugin_text_input_callback() {
    $text_input = get_option('hnp_mein_plugin_text_input');
    echo '<input type="text" name="hnp_mein_plugin_text_input" value="' . esc_attr($text_input) . '" />';
}

// Shortcode-Funktion zum Anzeigen der gespeicherten Daten im Frontend
function hnp_mein_plugin_shortcode() {
    $text_input = get_option('hnp_mein_plugin_text_input');
    return '<p>' . esc_html($text_input) . '</p>';
}
add_shortcode('hnp_mein_plugin', 'hnp_mein_plugin_shortcode');

// Prüfe auf Leerzeichen / Enter nach dem Abschluss-Tag
?>