<?php
/*
Plugin Name: HNP-Cookie Plugin
Description: Dieses Plugin zeigt einen Cookie-Button an und überprüft das Vorhandensein eines Cookies, um entsprechende Funktionen auszuführen.
Author: Christopher Rohde
Version: 1.0
Author URI: https://homepage-nach-preis.de/
License: GPLv3
*/

// Funktion zur Überprüfung des Cookies und Anzeige des Textes
function hnp_custom_function_with_cookie() {
  // Überprüfe, ob das Cookie vorhanden ist
  if (isset($_COOKIE['hnp_cookie_1'])) {
    // Rückgabe des gewünschten Textes
    return 'Cookie gefunden – Funktion aktiviert';
  }
}
add_shortcode('hnp_custom_shortcode', 'hnp_custom_function_with_cookie');

// Funktion zum Erzeugen des Cookie-Buttons
function hnp_set_cookie_button() {
    ob_start();
    ?>
    <form method="post">
        <input type="hidden" name="hnp_set_cookie" value="1" />
        <input type="submit" value="Cookie setzen" />
    </form>
    <?php
    return ob_get_clean();
}

// Funktion zum Setzen des Cookies
function hnp_set_cookie() {
    if (isset($_POST['hnp_set_cookie'])) {
        // 3600 = Sekunden, somit bleibt das Cookie 1 Stunde
        // Oder diese Zeile nutzen für 1 Jahr:  setcookie('hnp_cookie_1', 'cookie_value', strtotime('+1 year'), '/');
        setcookie('hnp_cookie_1', 'cookie_value', time() + 3600, '/'); 
        // Optional: Füge hier weitere Aktionen hinzu, die nach dem Setzen des Cookies ausgeführt werden sollen
    }
}

// Hook, um das Setzen des Cookies aufzurufen
add_action('init', 'hnp_set_cookie');

// Shortcodes registrieren
add_shortcode('hnp_set_cookie_button', 'hnp_set_cookie_button');
add_shortcode('hnp_display_cookie_button', 'hnp_display_cookie_button');

// Shortcode zum Anzeigen des Cookie-Buttons
function hnp_display_cookie_button() {
    // Überprüfe, ob das Cookie bereits gesetzt ist
    if (!isset($_COOKIE['hnp_cookie_1'])) {
        return do_shortcode('[hnp_set_cookie_button]');
    }
}