<?php
/*
* Plugin Name: HNP Dyn Template
* Plugin URI: https://homepage-nach-preis.de/
* Description: Erstellt 2 Button welche bei Betätigung die Template-Datei auswechseln. Shortcodes: hnp_template_switcher_buttons und hnp_template_switcher
* Version: 1.1
* Author: Christopher Rohde
* Author URI: https://homepage-nach-preis.de/
* License: HNP-Dyn-Template
*/

// Shortcode für den Template-Switcher hinzufügen
add_shortcode('hnp_template_switcher', 'hnp_custom_template_switcher_shortcode');

// Funktion zum Rendern des Shortcodes
function hnp_custom_template_switcher_shortcode() {
    ob_start();
    ?>
    <div id="hnp-template-container">
        <!-- Hier wird das Template dynamisch geladen -->
        <?php include_once(plugin_dir_path(__FILE__) . '/templates/hnp_template_1.php'); ?>
    </div>
    <?php
    return ob_get_clean();
}

// Shortcode für die Schaltflächen zum Wechseln der Templates hinzufügen
add_shortcode('hnp_template_switcher_buttons', 'hnp_custom_template_switcher_buttons_shortcode');

// Funktion zum Rendern des Shortcodes für die Schaltflächen
function hnp_custom_template_switcher_buttons_shortcode() {
    ob_start();
    ?>
    <button id="hnp-template1-btn">Template 1 laden</button>
    <button id="hnp-template2-btn">Template 2 laden</button>
    <?php
    return ob_get_clean();
}

// JavaScript zum Schalten der Templates hinzufügen
add_action('wp_footer', 'hnp_custom_template_switcher_js');

function hnp_custom_template_switcher_js() {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('hnp-template1-btn').addEventListener('click', function() {
            loadTemplate('hnp_template_1.php');
        });
        document.getElementById('hnp-template2-btn').addEventListener('click', function() {
            loadTemplate('hnp_template_2.php');
        });
    });

	function loadTemplate(templateUrl) {
		var xhr = new XMLHttpRequest();
		xhr.open('GET', '<?php echo plugins_url("templates/", __FILE__); ?>' + templateUrl, true);
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 200) {
				document.getElementById('hnp-template-container').innerHTML = xhr.responseText;
			}
		};
		xhr.send();
	}

    </script>
    <?php
}
